package com.wissamfawaz;

public class SLLBasedStack<T> implements Stack<T> {
    private SinglyLinkedList<T> sll;

    public SLLBasedStack() {
        sll = new SinglyLinkedList<>();
    }

    @Override
    public int size() {
        return sll.size();
    }

    @Override
    public boolean isEmpty() {
        return sll.isEmpty();
    }

    @Override
    public void push(T element) {
        sll.insertAtHead(element);
    }

    @Override
    public T pop() throws StackException {
        T toReturn = null;

        try {
            toReturn = sll.removeFromHead();
        } catch (EmptyListException e) {
            throw new StackException("Stack is empty!");
        }

        return toReturn;
    }

    @Override
    public T top() throws StackException {
        T toReturn = null;

        try {
            toReturn = sll.getHead();
        } catch (EmptyListException e) {
            throw new StackException("Stack is empty!");
        }

        return toReturn;
    }

    @Override
    public String toString() {
        return sll.toString();
    }

}
